/*------------------------------------------------------------------------------
    elomaxdriver: A linux kernel driver to control http://www.elomax.nl
                  usb-io modules
    Copyright (C) 2011  programming <at> kogro org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#include <linux/module.h>
#include "debug.h"
/*----------------------------------------------------------------------------*/
int debug_level = DBG_LVL_SUMRY;
/*
  the kernel build system does not allow to give others write permisson on
  a parameter. In file include/module_param.h this module_param macro
  translates over several steps to __module_param_call macro. That macro
  contains a 'call' to BUILD_BUG_ON_ZERO which evaluates to true when the
  S_IWOTH (2) is set in the permission. BUILD_BUG_ON_ZERO forces a compiler
  error "negative width in bit-field <anonymous>".
*/
module_param( 
  debug_level,
  int,
  S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH );
MODULE_PARM_DESC( debug_level, "0=nothing, 1=error, 2=sumry, 3=info, 4=debug" );
/*----------------------------------------------------------------------------*/
void
debug_show_level( void )
{
  switch( debug_level )
  {
    case DBG_LVL_NOTHING:
    {
      debug_msg( "debug-level nothing, no further messages\n" );
      break;
    }
    case DBG_LVL_ERROR:
    {
      debug_msg( "debug-level error, only error messages\n" );
      break;
    }
    default:
    case DBG_LVL_SUMRY:
    {
      debug_level = DBG_LVL_SUMRY;
      debug_msg(
        "debug-level summary, summary messages (connect, disconnect, "
        "open and close) plus error\n" );
      break;
    }
    case DBG_LVL_INFO:
    {
      debug_msg(
        "debug-level info, information messages (transferred data) "
        "plus summary (connect, disconnect, open and close)\n" );
      break;
    }
    case DBG_LVL_DEBUG:
    {
      debug_msg( "debug-level debug, all messages\n" );
      break;
    }
  }
}
/*----------------------------------------------------------------------------*/
