/*------------------------------------------------------------------------------
    elomaxdriver: A linux kernel driver to control http://www.elomax.nl
                  usb-io modules
    Copyright (C) 2011  programming <at> kogro org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#include <linux/init.h>
#include "debug.h"
#include "elomaxdriver.h"
#include "kernelmodule.h"
/*----------------------------------------------------------------------------*/
int __init
kernelmodule_init( void )
{
  int result = 0;

  debug_msg(
    "Copyright (C) 2011  programming <at> kogro org\n" );
  debug_msg(
    "This program comes with ABSOLUTELY NO WARRANTY; for details see\n" );
  debug_msg(
    "<http://www.gnu.org/licenses/>.\n" );
  debug_msg(
    "This is free software, and you are welcome to redistribute it under\n" );
  debug_msg(
    "certain conditions; see <http://www.gnu.org/licenses/> for details.\n" );

  debug_enter;

  debug_show_level();

  result = elomax_driver_construct();
  debug_err(
    0 == result,
    "driver construct failed with result %d\n",
    result );

  debug_leave;

  return result;
}
/*----------------------------------------------------------------------------*/
void __exit
kernelmodule_exit( void )
{
  debug_enter;

  elomax_driver_destruct();

  debug_leave;
}
/*----------------------------------------------------------------------------*/
module_init( kernelmodule_init );
module_exit( kernelmodule_exit );
/*----------------------------------------------------------------------------*/
