/*------------------------------------------------------------------------------
    elomaxdriver: A linux kernel driver to control http://www.elomax.nl
                  usb-io modules
    Copyright (C) 2011  programming <at> kogro org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#ifndef KERNELMODULE_H
#define KERNELMODULE_H
/*----------------------------------------------------------------------------*/
/**
  @file
  @brief
  This file contains functions to load and unload this package into the kernel.

  @details
  The user has the commands modprobe and rmmod to enter and release a module
  into/from the kernel. These commands trigger the kernel to execute the
  functions annotated by the @e module_init and @e module_exit macro's. In this
  package these are kernelmodule_init() and kernelmodule_exit()
  functions.
**/
/*----------------------------------------------------------------------------*/
/**
  @brief
  This function is executed when this module is inserted into the kernel
  (usually by a modprobe command).

  @details
  This function is announced to the kernel via the macro module_init as the
  entry point for this package. The kernel executes this function when the user
  modprobe's this package.

  This function calls elomax_driver_construct() which does the actual work.

  @return
  The succesfullness of the insertion.
**/
int
kernelmodule_init( void );
/*----------------------------------------------------------------------------*/
/**
  @brief
  This function is executed when this module is removed from the kernel
  (usually by a rmmod command).

  @details
  This function is announced to the kernel via the macro module_exit as
  another entry point for this package. The kernel uses this entry point when
  the user rmmod's this package. This function should clean up, so that the
  package safely can be removed from the kernel.

  This function delegates this clean up, by calling elomax_driver_destruct().
**/
void
kernelmodule_exit( void );
/*----------------------------------------------------------------------------*/
#endif
/*----------------------------------------------------------------------------*/
