/*------------------------------------------------------------------------------
    MockC:    a framework to implement mocking when unit-testing

    Copyright (C) 2011  programming <at> kogro org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#include "mockcomp.h"
#include "unit_supporting_mock.h"
#include "unit_under_test.h"
/*----------------------------------------------------------------------------*/
MOCKCOMP_ALLIMPL( int )
/*----------------------------------------------------------------------------*/
/* the test to execute */
/* this will be a CU_pSuite or equivalent */
int
main( int argc, char *argv[] )
{
  /* prepare the mock of being called */
  UnitSupporting_CallOne_reset();
  /* first call, return 5, check supplied parameter for value 3 */
  UnitSupporting_CallOne_expect( 5, equal_int, 3 );
  /* second call, return -5, don't check supplied parameter for value */
  UnitSupporting_CallOne_expect( -5, dontcare_int, 777 );

  /* perform the test, call the UnitUnderTest, check its return value */
  /* this will be a CU_ASSERT or equivalent */
  printf( "return result: %s\n", 3 == UnitUnderTest_CallOne( 3 ) ? " ok " : "fail" );

  /* check the mock, if it is called correctly */
  /* this will be a CU_ASSERT or equivalent */
  printf( "mock: %s\n", 0 != UnitSupporting_CallOne_verify() ? " ok " : "fail" );
}
/*----------------------------------------------------------------------------*/
