/*------------------------------------------------------------------------------
    MockC:    a framework to implement mocking when unit-testing

    Copyright (C) 2011  programming <at> kogro org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#ifndef MOCK0_H
#define MOCK0_H
/*----------------------------------------------------------------------------*/
/*
    Documentation is in the below included file "mock.h"
*/
/*----------------------------------------------------------------------------*/
#include "mock.h"
/*----------------------------------------------------------------------------*/
/*
    D E C L A R A T I O N
*/
/*----------------------------------------------------------------------------*/
#define MOCK_0( TReturn, Func )                                               \
  MOCK( TReturn, Func )                                                       \
  TReturn Func( void );                                                       \
  void                                                                        \
    Func##_expect(                                                            \
      TReturn );
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCK_VOID_0( Func )                                                   \
  MOCK( void, Func )                                                          \
  void Func( void );                                                          \
  void                                                                        \
    Func##_expect( void );
/*----------------------------------------------------------------------------*/
/*
    I M P L E M E N T A T I O N
*/
/*----------------------------------------------------------------------------*/
/*  Function */
#define MOCKFUNC_0( TReturn, Func )                                           \
  TReturn                                                                     \
  Func( void )                                                                \
  MOCKFUNC_BEGIN( Func )                                                      \
  MOCKFUNC_END( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKFUNC_VOID_0( Func )                                               \
  void                                                                        \
  Func( void )                                                                \
  MOCKFUNC_BEGIN( Func )                                                      \
  MOCKFUNC_VOID_END( Func )
/*----------------------------------------------------------------------------*/
/*  Expectation-variable */
#define MOCKVARIABLE_0( TReturn, Func )                                       \
  MOCKVARIABLE_BEGIN( TReturn, Func )                                         \
  MOCKVARIABLE_END( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKVARIABLE_VOID_0( Func )                                           \
  MOCKVARIABLE_VOID_BEGIN( Func )                                             \
  MOCKVARIABLE_END( Func )
/*----------------------------------------------------------------------------*/
/*  Expectation-function */
#define MOCKEXPECT_0( TReturn, Func )                                         \
  void                                                                        \
  Func##_expect(                                                              \
    TReturn Return )                                                          \
  {                                                                           \
    MOCKEXPECT_BEGIN( Func )                                                  \
      MOCKEXPECT_RETURN( TReturn, Func );                                     \
    MOCKEXPECT_END( Func );                                                   \
  }
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKEXPECT_VOID_0( Func )                                             \
  void                                                                        \
  Func##_expect( void )                                                       \
  {                                                                           \
    MOCKEXPECT_BEGIN( Func )                                                  \
    MOCKEXPECT_END( Func );                                                   \
  }
/*----------------------------------------------------------------------------*/
/*  THE implementation */
#define MOCKIMPL_0( TReturn, Func )                                           \
  MOCKVARIABLE_0( TReturn, Func )                                             \
  MOCKRESET( Func )                                                           \
  MOCKFUNC_0( TReturn, Func )                                                 \
  MOCKEXPECT_0( TReturn, Func )                                               \
  MOCKVERIFY( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKIMPL_VOID_0( Func )                                               \
  MOCKVARIABLE_VOID_0( Func )                                                 \
  MOCKRESET( Func )                                                           \
  MOCKFUNC_VOID_0( Func )                                                     \
  MOCKEXPECT_VOID_0( Func )                                                   \
  MOCKVERIFY( Func )
/*----------------------------------------------------------------------------*/
#endif
/*----------------------------------------------------------------------------*/
