/*------------------------------------------------------------------------------
    MockC:    a framework to implement mocking when unit-testing

    Copyright (C) 2011  programming <at> kogro org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#ifndef MOCK1_H
#define MOCK1_H
/*----------------------------------------------------------------------------*/
/*
    Documentation is in the below included file "mock.h"
*/
/*----------------------------------------------------------------------------*/
#include "mock.h"
/*----------------------------------------------------------------------------*/
/*
    D E C L A R A T I O N
*/
/*----------------------------------------------------------------------------*/
#define MOCK_1( TReturn, Func, TParam1 )                                      \
  MOCK( TReturn, Func )                                                       \
  TReturn Func( TParam1 );                                                    \
  void                                                                        \
    Func##_expect(                                                            \
      TReturn,                                                                \
      MOCK_COMPARE( TParam1 ),                                                \
      TParam1 );
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCK_VOID_1( Func, TParam1 )                                          \
  MOCK( void, Func )                                                          \
  void Func( TParam1 );                                                       \
  void                                                                        \
    Func##_expect(                                                            \
      MOCK_COMPARE( TParam1 ),                                                \
      TParam1 );
/*----------------------------------------------------------------------------*/
/*
    I M P L E M E N T A T I O N
*/
/*----------------------------------------------------------------------------*/
/*  Function */
#define MOCKFUNC_1( TReturn, Func, TParam1 )                                  \
  TReturn                                                                     \
  Func( TParam1 Param1 )                                                      \
  MOCKFUNC_BEGIN( Func )                                                      \
    MOCKFUNC_TEST_PARAM( Func, TParam1, 1 )                                   \
  MOCKFUNC_END( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKFUNC_VOID_1( Func, TParam1 )                                      \
  void                                                                        \
  Func( TParam1 Param1 )                                                      \
  MOCKFUNC_BEGIN( Func )                                                      \
    MOCKFUNC_TEST_PARAM( Func, TParam1, 1 )                                   \
  MOCKFUNC_VOID_END( Func )
/*----------------------------------------------------------------------------*/
/*  Expectation-variable */
#define MOCKVARIABLE_1( TReturn, Func, TParam1 )                              \
  MOCKVARIABLE_BEGIN( TReturn, Func )                                         \
    MOCKVARIABLE_ENTRY( 1, TParam1 )                                          \
  MOCKVARIABLE_END( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKVARIABLE_VOID_1( Func, TParam1 )                                  \
  MOCKVARIABLE_VOID_BEGIN( Func )                                             \
    MOCKVARIABLE_ENTRY( 1, TParam1 )                                          \
  MOCKVARIABLE_END( Func )
/*----------------------------------------------------------------------------*/
/*  Expectation-function */
#define MOCKEXPECT_1( TReturn, Func, TParam1 )                                \
  void                                                                        \
  Func##_expect(                                                              \
    TReturn Return,                                                           \
    MOCK_NAMED_COMPARE( TestParam1, TParam1 ),                                \
    TParam1 Param1 )                                                          \
  {                                                                           \
    MOCKEXPECT_BEGIN( Func )                                                  \
      MOCKEXPECT_RETURN( TReturn, Func );                                     \
      MOCKEXPECT_PARAM( Func, 1 );                                            \
    MOCKEXPECT_END( Func );                                                   \
  }
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKEXPECT_VOID_1( Func, TParam1 )                                    \
  void                                                                        \
  Func##_expect(                                                              \
    MOCK_NAMED_COMPARE( TestParam1, TParam1 ),                                \
    TParam1 Param1 )                                                          \
  {                                                                           \
    MOCKEXPECT_BEGIN( Func )                                                  \
      MOCKEXPECT_PARAM( Func, 1 );                                            \
    MOCKEXPECT_END( Func );                                                   \
  }
/*----------------------------------------------------------------------------*/
/*  THE implementation */
#define MOCKIMPL_1( TReturn, Func, TParam1 )                                  \
  MOCKVARIABLE_1( TReturn, Func, TParam1 )                                    \
  MOCKRESET( Func )                                                           \
  MOCKFUNC_1( TReturn, Func, TParam1 )                                        \
  MOCKEXPECT_1( TReturn, Func, TParam1 )                                      \
  MOCKVERIFY( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKIMPL_VOID_1( Func, TParam1 )                                      \
  MOCKVARIABLE_VOID_1( Func, TParam1 )                                        \
  MOCKRESET( Func )                                                           \
  MOCKFUNC_VOID_1( Func, TParam1 )                                            \
  MOCKEXPECT_VOID_1( Func, TParam1 )                                          \
  MOCKVERIFY( Func )
/*----------------------------------------------------------------------------*/
#endif
/*----------------------------------------------------------------------------*/
