/*------------------------------------------------------------------------------
    MockC:    a framework to implement mocking when unit-testing

    Copyright (C) 2011  programming <at> kogro org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#ifndef MOCK5_H
#define MOCK5_H
/*----------------------------------------------------------------------------*/
/*
    Documentation is int he below included file "mock.h"
*/
/*----------------------------------------------------------------------------*/
#include "mock.h"
/*----------------------------------------------------------------------------*/
/*
    D E C L A R A T I O N
*/
/*----------------------------------------------------------------------------*/
#define MOCK_5( TReturn, Func, TParam1, TParam2,                              \
                TParam3, TParam4, TParam5 )                                   \
  MOCK( TReturn, Func )                                                       \
  TReturn Func( TParam1, TParam2, TParam3, TParam4, TParam5 );                \
  void                                                                        \
    Func##_expect(                                                            \
      TReturn,                                                                \
      MOCK_COMPARE( TParam1 ),                                                \
      TParam1,                                                                \
      MOCK_COMPARE( TParam2 ),                                                \
      TParam2,                                                                \
      MOCK_COMPARE( TParam3 ),                                                \
      TParam3,                                                                \
      MOCK_COMPARE( TParam4 ),                                                \
      TParam4,                                                                \
      MOCK_COMPARE( TParam5 ),                                                \
      TParam5 );
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCK_VOID_5( Func, TParam1, TParam2,                                  \
                     TParam3, TParam4, TParam5 )                              \
  MOCK( void, Func )                                                          \
  void Func( TParam1, TParam2, TParam3, TParam4, TParam5 );                   \
  void                                                                        \
    Func##_expect(                                                            \
      MOCK_COMPARE( TParam1 ),                                                \
      TParam1,                                                                \
      MOCK_COMPARE( TParam2 ),                                                \
      TParam2,                                                                \
      MOCK_COMPARE( TParam3 ),                                                \
      TParam3,                                                                \
      MOCK_COMPARE( TParam4 ),                                                \
      TParam4,                                                                \
      MOCK_COMPARE( TParam5 ),                                                \
      TParam5 );
/*----------------------------------------------------------------------------*/
/*
    I M P L E M E N T A T I O N
*/
/*----------------------------------------------------------------------------*/
/*  Function */
#define MOCKFUNC_5( TReturn, Func, TParam1, TParam2,                          \
                    TParam3, TParam4, TParam5 )                               \
  TReturn                                                                     \
  Func( TParam1 Param1, TParam2 Param2, TParam3 Param3,                       \
        TParam4 Param4, TParam5 Param5 )                                      \
  MOCKFUNC_BEGIN( Func )                                                      \
    MOCKFUNC_TEST_PARAM( Func, TParam1, 1 )                                   \
    MOCKFUNC_TEST_PARAM( Func, TParam2, 2 )                                   \
    MOCKFUNC_TEST_PARAM( Func, TParam3, 3 )                                   \
    MOCKFUNC_TEST_PARAM( Func, TParam4, 4 )                                   \
    MOCKFUNC_TEST_PARAM( Func, TParam5, 5 )                                   \
  MOCKFUNC_END( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKFUNC_VOID_5( Func, TParam1, TParam2, TParam3,                     \
                         TParam4, TParam5 )                                   \
  void                                                                        \
  Func( TParam1 Param1, TParam2 Param2, TParam3 Param3,                       \
        TParam4 Param4, TParam5 Param5 )                                      \
  MOCKFUNC_BEGIN( Func )                                                      \
    MOCKFUNC_TEST_PARAM( Func, TParam1, 1 )                                   \
    MOCKFUNC_TEST_PARAM( Func, TParam2, 2 )                                   \
    MOCKFUNC_TEST_PARAM( Func, TParam3, 3 )                                   \
    MOCKFUNC_TEST_PARAM( Func, TParam4, 4 )                                   \
    MOCKFUNC_TEST_PARAM( Func, TParam5, 5 )                                   \
  MOCKFUNC_VOID_END( Func )
/*----------------------------------------------------------------------------*/
/*  Expectation-variable */
#define MOCKVARIABLE_5( TReturn, Func, TParam1, TParam2,                      \
                        TParam3, TParam4, TParam5 )                           \
  MOCKVARIABLE_BEGIN( TReturn, Func )                                         \
    MOCKVARIABLE_ENTRY( 1, TParam1 )                                          \
    MOCKVARIABLE_ENTRY( 2, TParam2 )                                          \
    MOCKVARIABLE_ENTRY( 3, TParam3 )                                          \
    MOCKVARIABLE_ENTRY( 4, TParam4 )                                          \
    MOCKVARIABLE_ENTRY( 5, TParam5 )                                          \
  MOCKVARIABLE_END( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKVARIABLE_VOID_5( Func, TParam1, TParam2,                          \
                        TParam3, TParam4, TParam5 )                           \
  MOCKVARIABLE_VOID_BEGIN( Func )                                             \
    MOCKVARIABLE_ENTRY( 1, TParam1 )                                          \
    MOCKVARIABLE_ENTRY( 2, TParam2 )                                          \
    MOCKVARIABLE_ENTRY( 3, TParam3 )                                          \
    MOCKVARIABLE_ENTRY( 4, TParam4 )                                          \
    MOCKVARIABLE_ENTRY( 5, TParam5 )                                          \
  MOCKVARIABLE_END( Func )
/*----------------------------------------------------------------------------*/
/*  Expectation-function */
#define MOCKEXPECT_5( TReturn, Func, TParam1, TParam2,                        \
                        TParam3, TParam4, TParam5 )                           \
  void                                                                        \
  Func##_expect(                                                              \
    TReturn Return,                                                           \
    MOCK_NAMED_COMPARE( TestParam1, TParam1 ),                                \
    TParam1 Param1,                                                           \
    MOCK_NAMED_COMPARE( TestParam2, TParam2 ),                                \
    TParam2 Param2,                                                           \
    MOCK_NAMED_COMPARE( TestParam3, TParam3 ),                                \
    TParam3 Param3,                                                           \
    MOCK_NAMED_COMPARE( TestParam4, TParam4 ),                                \
    TParam4 Param4,                                                           \
    MOCK_NAMED_COMPARE( TestParam5, TParam5 ),                                \
    TParam5 Param5 )                                                          \
  {                                                                           \
    MOCKEXPECT_BEGIN( Func )                                                  \
      MOCKEXPECT_RETURN( TReturn, Func );                                     \
      MOCKEXPECT_PARAM( Func, 1 );                                            \
      MOCKEXPECT_PARAM( Func, 2 );                                            \
      MOCKEXPECT_PARAM( Func, 3 );                                            \
      MOCKEXPECT_PARAM( Func, 4 );                                            \
      MOCKEXPECT_PARAM( Func, 5 );                                            \
    MOCKEXPECT_END( Func );                                                   \
  }
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKEXPECT_VOID_5( Func, TParam1, TParam2,                            \
                        TParam3, TParam4, TParam5 )                           \
  void                                                                        \
  Func##_expect(                                                              \
    MOCK_NAMED_COMPARE( TestParam1, TParam1 ),                                \
    TParam1 Param1,                                                           \
    MOCK_NAMED_COMPARE( TestParam2, TParam2 ),                                \
    TParam2 Param2,                                                           \
    MOCK_NAMED_COMPARE( TestParam3, TParam3 ),                                \
    TParam3 Param3,                                                           \
    MOCK_NAMED_COMPARE( TestParam4, TParam4 ),                                \
    TParam4 Param4,                                                           \
    MOCK_NAMED_COMPARE( TestParam5, TParam5 ),                                \
    TParam5 Param5 )                                                          \
  {                                                                           \
    MOCKEXPECT_BEGIN( Func )                                                  \
      MOCKEXPECT_PARAM( Func, 1 );                                            \
      MOCKEXPECT_PARAM( Func, 2 );                                            \
      MOCKEXPECT_PARAM( Func, 3 );                                            \
      MOCKEXPECT_PARAM( Func, 4 );                                            \
      MOCKEXPECT_PARAM( Func, 5 );                                            \
    MOCKEXPECT_END( Func );                                                   \
  }
/*----------------------------------------------------------------------------*/
/*  THE implementation */
#define MOCKIMPL_5( TReturn, Func, TParam1, TParam2,                          \
                        TParam3, TParam4, TParam5 )                           \
  MOCKVARIABLE_5( TReturn, Func, TParam1, TParam2,                            \
       TParam3, TParam4, TParam5 )                                            \
  MOCKRESET( Func )                                                           \
  MOCKFUNC_5( TReturn, Func, TParam1, TParam2,                                \
       TParam3, TParam4, TParam5 )                                            \
  MOCKEXPECT_5( TReturn, Func, TParam1, TParam2,                              \
       TParam3, TParam4, TParam5 )                                            \
  MOCKVERIFY( Func )
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKIMPL_VOID_5( Func, TParam1, TParam2,                              \
                        TParam3, TParam4, TParam5 )                           \
  MOCKVARIABLE_VOID_5( Func, TParam1, TParam2,                                \
       TParam3, TParam4, TParam5 )                                            \
  MOCKRESET( Func )                                                           \
  MOCKFUNC_VOID_5( Func, TParam1, TParam2,                                    \
       TParam3, TParam4, TParam5 )                                            \
  MOCKEXPECT_VOID_5( Func, TParam1, TParam2,                                  \
       TParam3, TParam4, TParam5 )                                            \
  MOCKVERIFY( Func )
/*----------------------------------------------------------------------------*/
#endif
/*----------------------------------------------------------------------------*/
