/*------------------------------------------------------------------------------
    MockC:    a framework to implement mocking when unit-testing

    Copyright (C) 2011  programming <at> kogro org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
------------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
#ifndef MOCKCOMP_H
#define MOCKCOMP_H
/*----------------------------------------------------------------------------*/
#include <stdio.h>
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define _unused_    __attribute__((unused))
/*----------------------------------------------------------------------------*/
/*
    D E C L A R A T I O N
*/
/*----------------------------------------------------------------------------*/
#define MOCKSHOW( TType )                                                     \
  void MockShow##TType( TType a_Param );
/*----------------------------------------------------------------------------*/
#define MOCKCOMP_EQUAL( TType )                                               \
  int equal_##TType( TType left, TType right );
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKCOMP_UNEQUAL( TType )                                             \
  int unequal_##TType( TType left, TType right );
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKCOMP_DONTCARE( TType )                                            \
  int dontcare_##TType( TType left, TType right );
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKCOMP_PASSBYREF( TType )                                           \
  int passbyref_##TType( TType left, TType right );
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKCOMP_ALL( TType )                                                 \
  MOCKCOMP_EQUAL( TType )                                                     \
  MOCKCOMP_UNEQUAL( TType )                                                   \
  MOCKCOMP_DONTCARE( TType )
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*
    I M P L E M E N T A T I O N
*/
/*----------------------------------------------------------------------------*/
#define MOCKSHOWIMPL( TType, Format )                                         \
  void                                                                        \
  MockShow##TType( TType a_Param )                                            \
  {                                                                           \
    printf( Format, a_Param );                                                \
  }
/*----------------------------------------------------------------------------*/
#define MOCKCOMP_EQUALIMPL( TType )                                           \
  int                                                                         \
  equal_##TType( TType left, TType right )                                    \
  {                                                                           \
    return left == right;                                                     \
  }
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKCOMP_UNEQUALIMPL( TType )                                         \
  int                                                                         \
  unequal_##TType( TType left, TType right )                                  \
  {                                                                           \
    return ! equal_##TType( left, right );                                    \
  }
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKCOMP_DONTCAREIMPL( TType )                                        \
  int                                                                         \
  dontcare_##TType( TType _unused_ left, TType _unused_ right )               \
  {                                                                           \
    return 1;                                                                 \
  }
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKCOMP_PASSBYREFIMPL( TType )                                       \
  int                                                                         \
  passbyref_##TType( TType actual, TType expect )                             \
  {                                                                           \
    *actual = *expect;                                                        \
    return 1;                                                                 \
  }
/* --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  --  -- */
#define MOCKCOMP_ALLIMPL( TType )                                             \
  MOCKCOMP_EQUALIMPL( TType )                                                 \
  MOCKCOMP_UNEQUALIMPL( TType )                                               \
  MOCKCOMP_DONTCAREIMPL( TType )
/*----------------------------------------------------------------------------*/
#endif
/*----------------------------------------------------------------------------*/
